import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the shape of the input grid
    rows, cols = input_grid.shape
    
    # Create a new array with double the number of columns
    output_grid = np.zeros((rows, cols*2), dtype=int)
    
    # Copy the input grid to the left side of the output grid
    output_grid[:, :cols] = input_grid
    
    # Copy the input grid to the right side of the output grid
    output_grid[:, cols:] = input_grid
    
    return output_grid
    