import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find non-black blocks in the leftmost column
    for i in range(input_grid.shape[0]):
        if input_grid[i, 0] != black:
            for j in range(input_grid.shape[1]):
                if input_grid[i, j] == teal:
                    input_grid[i, j] = input_grid[i, 0]
                    break
    
    # Find non-black blocks in the rightmost column
    for i in range(input_grid.shape[0]):
        if input_grid[i, -1] != black:
            for j in range(input_grid.shape[1]-1, -1, -1):
                if input_grid[i, j] == teal:
                    input_grid[i, j] = input_grid[i, -1]
                    break
    
    # Find non-black blocks in the first row
    for j in range(input_grid.shape[1]):
        if input_grid[0, j] != black:
            for i in range(input_grid.shape[0]):
                if input_grid[i, j] == teal:
                    input_grid[i, j] = input_grid[0, j]
                    break
    
    # Find non-black blocks in the last row
    for j in range(input_grid.shape[1]):
        if input_grid[-1, j] != black:
            for i in range(input_grid.shape[0]-1, -1, -1):
                if input_grid[i, j] == teal:
                    input_grid[i, j] = input_grid[-1, j]
                    break
    
    return input_grid