import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    output_grid = np.copy(input_grid) # create an output grid with the same shape as the input grid
    
    # start from the bottom-left corner
    i, j = input_grid.shape[0]-1, 0
    
    # loop until we reach the top edge
    while i >= 0:
        # loop to move right-up
        while i > 0 and j < input_grid.shape[1]-1:
            output_grid[i-1][j+1] = blue
            i -= 1
            j += 1
        
        # loop to move left-up
        while i >= 0 and j > 0:
            output_grid[i-1][j-1] = blue
            i -= 1
            j -= 1
    
    return output_grid