import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Count the number of colors except black
    color_counts = np.bincount(input_grid[input_grid != black])
    num_colors = len(color_counts)

    # Find the leftmost position of colors except black
    leftmost_positions = np.full(num_colors, np.inf)
    for color in range(num_colors):
        if color_counts[color] > 0:
            leftmost_positions[color] = np.where(input_grid == color)[1].min()

    # Find the most numerous and equal colors
    most_common_count = color_counts.max()
    most_common_colors = np.where(color_counts == most_common_count)[0]

    # Generate output grid
    output_grid = np.zeros((most_common_count, len(most_common_colors)), dtype=int)
    for i, color in enumerate(most_common_colors):
        output_grid[:, i] = np.where(input_grid == color)[0][:most_common_count]

    # Paint columns in output to the original color
    sorted_colors = most_common_colors[np.argsort(leftmost_positions[most_common_colors])]
    for i, color in enumerate(sorted_colors):
        output_grid[:, i][output_grid[:, i] < np.inf] = color

    # Return output grid
    return output_grid
    
    