import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    """
    Mirror the input grid according to the diagonal from top left to bottom right.
    """
    # Get the shape of the input grid
    rows, cols = input_grid.shape

    # Create an empty output grid with the same shape as the input grid
    output_grid = np.zeros((rows, cols), dtype=int)

    # Iterate over each element in the input grid
    for i in range(rows):
        for j in range(cols):
            # Mirror the element according to the diagonal from top left to bottom right
            output_grid[i][j] = input_grid[j][i]

    return output_grid