import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Flip the grid left and right
    flipped_lr = np.fliplr(input_grid)

    # Concatenate the two grids horizontally
    concatenated_h = np.concatenate((input_grid, flipped_lr), axis=1)

    # Flip the whole grid up and down
    flipped_ud = np.flipud(concatenated_h)

    # Concatenate the two grids vertically
    concatenated_v = np.concatenate((concatenated_h, flipped_ud), axis=0)

    return concatenated_v