import numpy as np

# Define color codes
(black, blue, red, green, yellow, grey, pink, orange, teal, maroon) = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Step 1: Find center points
    center_points = []
    for i in range(1, input_grid.shape[0]-1):
        for j in range(1, input_grid.shape[1]-1):
            if input_grid[i,j] != black and \
               input_grid[i-1,j] != black and \
               input_grid[i+1,j] != black and \
               input_grid[i,j-1] != black and \
               input_grid[i,j+1] != black:
                center_points.append((i,j))

    # Step 2: Modify colors
    for center in center_points:
        i, j = center
        c1 = input_grid[i,j]
        c2 = input_grid[i,j-1]
        input_grid[i-1,j-1] = c1
        input_grid[i-2,j-2] = c1
        input_grid[i-1,j+1] = c1
        input_grid[i-2,j+2] = c1
        input_grid[i+1,j+1] = c1
        input_grid[i+2,j+2] = c1
        input_grid[i+1,j-1] = c1
        input_grid[i+2,j-2] = c1
        input_grid[i-2,j] = c2
        input_grid[i+2,j] = c2
        input_grid[i,j-2] = c2
        input_grid[i,j+2] = c2

    # Step 3: Return modified image matrix
    return input_grid