import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    output_grid = np.copy(input_grid)
    rows, cols = input_grid.shape
    list_blue = []
    x1, y1, x2, y2 = None, None, None, None
    
    # Find the coordinates of the first and last blue points
    for i in range(rows):
        for j in range(cols):
            if input_grid[i][j] == blue:
                list_blue.append((i,j))
                if x1 is None:
                    x1, y1 = i, j
                x2, y2 = i, j
    
    # Traverse the list of blue points and find the point of symmetry
    for x, y in list_blue:
        x3, y3 = x1 + x2 - x, y1 + y2 - y
        if x3 >= 0 and x3 < rows and y3 >= 0 and y3 < cols and input_grid[x3][y3] == black:
            output_grid[x3][y3] = red
    
    return output_grid