import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the teal point in the input grid
    teal_point = np.argwhere(input_grid == teal)[0]

    # Create a copy of the input grid to modify
    output_grid = np.copy(input_grid)

    # Draw the first flight of steps in the direction of up and right
    current_point = teal_point
    while current_point[0] >= 0 and current_point[1] < input_grid.shape[1]:
        if current_point[0]-1 >= 0:
            output_grid[current_point[0]-1, current_point[1]] = grey
        if current_point[0]-2 >= 0:
            output_grid[current_point[0]-2, current_point[1]] = grey
        if current_point[0]-2 >= 0 and current_point[1]+1 < input_grid.shape[1]:
            output_grid[current_point[0]-2, current_point[1]+1] = grey
        current_point = np.array([current_point[0]-2, current_point[1]+2])
        if current_point[0] >= 0 and current_point[1] < input_grid.shape[1]:
            output_grid[current_point[0], current_point[1]] = grey

    # Draw the second flight of steps in the direction of down and left
    current_point = teal_point
    while current_point[0] < input_grid.shape[0] and current_point[1] >= 0:
        if current_point[0]+1 < input_grid.shape[0]:
            output_grid[current_point[0]+1, current_point[1]] = grey
        if current_point[0]+2 < input_grid.shape[0]:
            output_grid[current_point[0]+2, current_point[1]] = grey
        if current_point[0]+2 < input_grid.shape[0] and current_point[1]-1 >= 0:
            output_grid[current_point[0]+2, current_point[1]-1] = grey
        current_point = np.array([current_point[0]+2, current_point[1]-2])
        if current_point[0] < input_grid.shape[0] and current_point[1] >= 0:
            output_grid[current_point[0], current_point[1]] = grey

    return output_grid


