import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    output_grid = input_grid.copy() # create a copy of the input grid

    # loop through each pixel in the grid
    for i in range(9):
        for j in range(9):
            if input_grid[i][j] == black: # if the pixel is black
                neighbours = []
                if i > 0:
                    neighbours.append(input_grid[i-1][j])
                if i < 8:
                    neighbours.append(input_grid[i+1][j])
                if j > 0:
                    neighbours.append(input_grid[i][j-1])
                if j < 8:
                    neighbours.append(input_grid[i][j+1])
                # check if the pixel has at least two non-black neighbours
                if len(neighbours) - neighbours.count(black) >= 2:
                    output_grid[i][j] = orange # change the pixel to orange

    # check if there are 18 non-black pixels
    while np.count_nonzero(output_grid != black) < 18:
        # loop through each pixel in the grid
        for i in range(9):
            for j in range(9):
                if output_grid[i][j] == black: # if the pixel is black
                    neighbours = []
                    if i > 0:
                        neighbours.append(output_grid[i-1][j])
                    if i < 8:
                        neighbours.append(output_grid[i+1][j])
                    if j > 0:
                        neighbours.append(output_grid[i][j-1])
                    if j < 8:
                        neighbours.append(output_grid[i][j+1])
                    # check if the pixel has at least two non-black neighbours
                    if len(neighbours) - neighbours.count(black) >= 2:
                        output_grid[i][j] = orange # change the pixel to orange
                        # check if there are 18 non-black pixels
                        if np.count_nonzero(output_grid != black) == 18:
                            break
            else:
                continue
            break

    return output_grid