import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the location of the gray line
    x_gray = np.where(input_grid == grey)[0][0]

    # Find the location of all red and blue pixels
    red_pixels = np.where(input_grid == red)
    blue_pixels = np.where(input_grid == blue)

    # Draw red vertical lines from each red pixel to the gray line
    for i in range(len(red_pixels[0])):
        x = red_pixels[0][i]
        y = red_pixels[1][i]
        if x < x_gray:
            input_grid[x:x_gray, y] = red
        elif x > x_gray:
            input_grid[x_gray+1:x+1, y] = red

    # Draw blue lines from each blue pixel to the upper or lower boundary of the grid
    for i in range(len(blue_pixels[0])):
        x = blue_pixels[0][i]
        y = blue_pixels[1][i]
        if x < x_gray:
            input_grid[0:x+1, y] = blue
        else:
            input_grid[x:10, y] = blue

    return input_grid