import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    output_grid = input_grid.copy() # create a copy of the input grid

    # find all 2x2 grids that are not black
    for i in range(9):
        for j in range(9):
            subgrid = input_grid[i:i+2, j:j+2]
            if np.all(subgrid != black):
                # count the number of colors in the subgrid
                colors = np.unique(subgrid)
                num_colors = len(colors) - int(black in colors)

                # change the n rows and 2 columns under the subgrid to green
                output_grid[i+2:i+2+num_colors, j:j+2] = green

    return output_grid