import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Check if the input grid has a repeated pattern horizontally
    for i in range(1, input_grid.shape[0]//2 + 1):
        if np.array_equal(input_grid[:i,:], input_grid[i:i*2,:]):
            return input_grid[:i,:]

    # Check if the input grid has a repeated pattern vertically
    for j in range(1, input_grid.shape[1]//2 + 1):
        if np.array_equal(input_grid[:,:j], input_grid[:,j:j*2]):
            return input_grid[:,:j]

    # If no repeated pattern is found, return the input grid
    return input_grid
