import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find all black grids that can be reached from the starting point (0, 0)
    visited = set()
    queue = [(0, 0)]
    while queue:
        x, y = queue.pop(0)
        if input_grid[x][y] == black and (x, y) not in visited:
            visited.add((x, y))
            for dx, dy in [(0, 1), (0, -1), (1, 0), (-1, 0), (1, 1), (-1, -1), (1, -1), (-1, 1)]:
                nx, ny = x + dx, y + dy
                if 0 <= nx < input_grid.shape[0] and 0 <= ny < input_grid.shape[1] and input_grid[nx][ny] == black:
                    queue.append((nx, ny))

    # Color all visited black grids yellow
    for i, j in visited:
        input_grid[i][j] = yellow

    # Color all unvisited black grids pink
    for i in range(input_grid.shape[0]):
        for j in range(input_grid.shape[1]):
            if input_grid[i][j] == black and (i, j) not in visited:
                input_grid[i][j] = pink

    # Color all blue grids adjacent to pink grids green
    for i in range(input_grid.shape[0]):
        for j in range(input_grid.shape[1]):
            if input_grid[i][j] == pink:
                for dx, dy in [(0, 1), (0, -1), (1, 0), (-1, 0), (1, 1), (-1, -1), (1, -1), (-1, 1)]:
                    nx, ny = i + dx, j + dy
                    if 0 <= nx < input_grid.shape[0] and 0 <= ny < input_grid.shape[1] and input_grid[nx][ny] == blue:
                        input_grid[nx][ny] = green

    # Color all yellow grids black
    for i in range(input_grid.shape[0]):
        for j in range(input_grid.shape[1]):
            if input_grid[i][j] == yellow:
                input_grid[i][j] = black

    # Color all pink grids black
    for i in range(input_grid.shape[0]):
        for j in range(input_grid.shape[1]):
            if input_grid[i][j] == pink:
                input_grid[i][j] = black

    return input_grid
