import numpy as np

# Define color codes
(black, blue, red, green, yellow, grey, pink, orange, teal, maroon) = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Step 1: Obtain height and width of input image
    h, w = input_grid.shape

    # Step 2: Retrieve pattern_grid
    pattern_grid = input_grid[:h, :4]

    # Step 3: Traverse image matrix by column and apply pattern_grid
    for j in range(w):
        input_grid[:, j] = pattern_grid[:, j%4]

    return input_grid