import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Create a copy of the input grid to modify
    output_grid = np.copy(input_grid)
    
    # Iterate over each pixel in the grid
    for i in range(input_grid.shape[0]):
        for j in range(input_grid.shape[1]):
            # Check if the current pixel is green
            if input_grid[i][j] == green:
                # Check if there is a green pixel to the left or right
                if (j > 0 and input_grid[i][j-1] == green) or (j < input_grid.shape[1]-1 and input_grid[i][j+1] == green):
                    output_grid[i][j] = teal
                # Check if there is a green pixel above or below
                elif (i > 0 and input_grid[i-1][j] == green) or (i < input_grid.shape[0]-1 and input_grid[i+1][j] == green):
                    output_grid[i][j] = teal
    
    return output_grid
