import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    output_grid = np.copy(input_grid) # create a copy of the input grid
    
    # loop through each column of the grid
    for col in range(input_grid.shape[1]):
        # check if the column number is divisible by 3
        if col % 3 == 0:
            # if yes, color all yellow pixels in that column to pink
            output_grid[:, col][output_grid[:, col] == yellow] = pink
    
    return output_grid

