import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the shape of the input grid
    rows, cols = input_grid.shape
    
    # Create an output grid with the same shape as the input grid
    output_grid = np.zeros((rows, cols), dtype=int)
    
    # Loop through each pixel in the input grid
    for row in range(rows):
        for col in range(cols):
            # If the pixel is not black, translate it down by 1 pixel
            if input_grid[row][col] != black:
                output_grid[row+1][col] = input_grid[row][col]
    
    return output_grid
