import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the red pixel
    red_pixel = np.where(input_grid == red)
    row, col = red_pixel[0][0], red_pixel[1][0]
    
    # Find the neighbors
    neighbors = []
    if row > 0 and col > 0:
        neighbors.append((row-1, col-1)) # Upper left
    if row > 0 and col < input_grid.shape[1]-1:
        neighbors.append((row-1, col+1)) # Upper right
    if row < input_grid.shape[0]-1 and col > 0:
        neighbors.append((row+1, col-1)) # Bottom left
    if row < input_grid.shape[0]-1 and col < input_grid.shape[1]-1:
        neighbors.append((row+1, col+1)) # Bottom right
    
    # Update the neighbors and delete the red pixel
    output_grid = input_grid.copy()
    output_grid[row, col] = black
    for neighbor in neighbors:
        if input_grid[neighbor] == black:
            if neighbor[0] < row and neighbor[1] < col:
                output_grid[neighbor] = green
            elif neighbor[0] < row and neighbor[1] > col:
                output_grid[neighbor] = pink
            elif neighbor[0] > row and neighbor[1] < col:
                output_grid[neighbor] = teal
            elif neighbor[0] > row and neighbor[1] > col:
                output_grid[neighbor] = orange
    
    return output_grid