import numpy as np
from typing import *

(black, blue, red, green, yellow, grey, pink, orange, teal, maroon) = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the 3x3 grids with black centers
    for i in range(1, input_grid.shape[0]-1):
        for j in range(1, input_grid.shape[1]-1):
            if input_grid[i][j] == black and \
               input_grid[i-1][j] == blue and \
               input_grid[i+1][j] == blue and \
               input_grid[i][j-1] == blue and \
               input_grid[i][j+1] == blue:
                # Replace the 3x3 grid with black color
                input_grid[i-1:i+2, j-1:j+2] = black
                # Put a red cross-shaped object at the center
                input_grid[i][j-1:j+2] = red
                input_grid[i-1:i+2, j] = red
    return input_grid