import numpy as np
from typing import *
(black, blue, red, green, yellow, grey, pink, orange, teal, maroon) = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Create empty output grid
    output_grid = np.zeros_like(input_grid)
    
    # Move teal pixels to next row
    for i in range(input_grid.shape[0]-1):
        for j in range(input_grid.shape[1]):
            if input_grid[i][j] == teal:
                output_grid[i+1][j] = red
            else:
                output_grid[i+1][j] = input_grid[i+1][j]
    
    # Copy first row to output grid
    output_grid[0] = input_grid[0]
    
    # Set all teal pixels in output grid to black
    output_grid[output_grid == teal] = black
    
    return output_grid