import numpy as np
from typing import *

(black, blue, red, green, yellow, grey, pink, orange, teal, maroon) = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the index of the grey column
    grey_col_idx = np.where(input_grid[0] == grey)[0][0]
    
    # Split the input grid into left and right parts
    left_part = input_grid[:, :grey_col_idx]
    right_part = input_grid[:, grey_col_idx+1:]
    
    # Flip the right part horizontally
    flipped_right_part = np.fliplr(right_part)
    
    # Create a mask that selects the black pixels in the left part
    mask = left_part == black
    
    # Place the flipped right part over the left part, without changing the color of non-black pixels in the left part
    left_part[:, -flipped_right_part.shape[1]:][mask] = flipped_right_part[mask]
    
    return left_part