import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the left, right, up, down edges of the non-blue pixels
    rows, cols = np.where(input_grid != blue)
    left_edge = cols.min()
    right_edge = cols.max()
    up_edge = rows.min()
    down_edge = rows.max()
    
    # Remain the pixels inside the edges
    output_grid = input_grid[up_edge:down_edge+1, left_edge:right_edge+1]
    
    # Make blue pixels black
    output_grid[output_grid == blue] = black
    
    return output_grid