import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    color_list = []
    for col in range(input_grid.shape[1]):
        for row in range(input_grid.shape[0]):
            if input_grid[row][col] != black:
                color_list.append(input_grid[row][col])
                break
    color_list = color_list[:9]
    color_list = [color_list[i:i+3] for i in range(0, len(color_list), 3)]
    color_list[1] = color_list[1][::-1]
    output_grid = np.zeros((3, 3), dtype=int)
    for i in range(3):
        for j in range(3):
            output_grid[i][j] = color_list[i][j]
    return output_grid