#!/usr/bin/env bash
set -xeuo pipefail

project_name=''
exp_name=''
MODEL_PATH=
TRAIN_FILE=
TEST_FILE=


# TORCH DEBUG
export TORCH_CPP_LOG_LEVEL=INFO
export TORCH_DISTRIBUTED_DEBUG=INFO
#export VLLM_ATTENTION_BACKEND=XFORMERS

# NCCL DEBUG
export NCCL_DEBUG=INFO
#export NCCL_DEBUG=WARN
export NCCL_DEBUG_SUBSYS=INIT,P2P,NET,GRAPH,ENV,DYNDBG
export NCCL_ASYNC_ERROR_HANDLING=1
export NCCL_IB_TIMEOUT=120
export NCCL_IB_QPS_PER_CONNECTION=8
export NCCL_IB_RETRY_CNT=15

export PYTORCH_CUDA_ALLOC_CONF='max_split_size_mb:512'
export TOKENIZERS_PARALLELISM=false
export OMP_NUM_THREADS=4
export CUDA_DEVICE_MAX_CONNECTIONS=1
export CUDA_VISIBLE_DEVICES=$(seq -s "," 0 $(nvidia-smi --list-gpus | wc -l | awk '{print $1-1}'))
export REQUIRED_GPUS=$(echo $CUDA_VISIBLE_DEVICES | tr ',' ' ' | wc -w)
export NCCL_NVLS_ENABLE=0

adv_estimator=grpo

use_kl_in_reward=False
kl_coef=0.0
use_kl_loss=False
kl_loss_coef=0.0

clip_ratio_low=0.2
clip_ratio_high=0.28

max_prompt_length=$((1024 * 2))
max_response_length=$((1024 * 20))
enable_overlong_buffer=True
overlong_buffer_len=$((1024 * 4))
overlong_penalty_factor=1.0

loss_agg_mode="token-mean"

enable_filter_groups=True
filter_groups_metric=acc
max_num_gen_batches=10
train_prompt_bsz=512
gen_prompt_bsz=$((train_prompt_bsz * 3))
n_resp_per_prompt=16
train_prompt_mini_bsz=32

# Ray
CURRPWD=""
WORKING_DIR=${WORKING_DIR:-"${CURRPWD}"}
RUNTIME_ENV=${RUNTIME_ENV:-"${WORKING_DIR}/verl/trainer/runtime_env.yaml"}
NNODES=${NNODES:-1}
# Paths
export WANDB_DIR="wandb_log/${exp_name}"
export TENSORBOARD_DIR="log/tensorboard_log/${exp_name}"
export GENERATION_LOG_DIR="dapo/general_records/${exp_name}"
export CORRECT_CACHE_DIR="dapo/general_records/${exp_name}"
export PYTHONUNBUFFERED=1
export TORCH_NCCL_AVOID_RECORD_STREAMS="1"
export HYDRA_FULL_ERROR=1
CKPTS_DIR="${project_name}/${exp_name}"

mkdir -p $WANDB_DIR $TENSORBOARD_DIR $GENERATION_LOG_DIR $CORRECT_CACHE_DIR $CKPTS_DIR

# Algorithm
temperature=1.0
top_p=1.0
top_k=-1 # 0 for HF rollout, -1 for vLLM rollout
val_top_p=0.7

# Performance Related Parameter
sp_size=4
use_dynamic_bsz=True
actor_ppo_max_token_len=$(((max_prompt_length + max_response_length)))
infer_ppo_max_token_len=$(((max_prompt_length + max_response_length)))
offload=True
gen_tp=4
fsdp_size=-1

# reference run wandb: https://wandb.ai/verl-org/DAPO%20Reproduction%20on%20verl/runs/ow47vvon?nw=nwusertongyuxuan361

python3 -m recipe.dapo.main_dapo \
  data.train_files="${TRAIN_FILE}" \
  data.val_files="${TEST_FILE}" \
  data.prompt_key=prompt \
  data.truncation='left' \
  data.max_prompt_length=${max_prompt_length} \
  data.max_response_length=${max_response_length} \
  data.gen_batch_size=${gen_prompt_bsz} \
  data.train_batch_size=${train_prompt_bsz} \
  data.shuffle=False \
  actor_rollout_ref.rollout.n=${n_resp_per_prompt} \
  algorithm.adv_estimator=${adv_estimator} \
  algorithm.use_kl_in_reward=${use_kl_in_reward} \
  algorithm.kl_ctrl.kl_coef=${kl_coef} \
  actor_rollout_ref.actor.use_kl_loss=${use_kl_loss} \
  actor_rollout_ref.actor.kl_loss_coef=${kl_loss_coef} \
  actor_rollout_ref.actor.clip_ratio_low=${clip_ratio_low} \
  actor_rollout_ref.actor.clip_ratio_high=${clip_ratio_high} \
  actor_rollout_ref.actor.clip_ratio_c=10.0 \
  algorithm.filter_groups.enable=${enable_filter_groups} \
  algorithm.filter_groups.max_num_gen_batches=${max_num_gen_batches} \
  algorithm.filter_groups.metric=${filter_groups_metric} \
  actor_rollout_ref.model.use_remove_padding=True \
  actor_rollout_ref.actor.use_dynamic_bsz=${use_dynamic_bsz} \
  actor_rollout_ref.ref.log_prob_use_dynamic_bsz=${use_dynamic_bsz} \
  actor_rollout_ref.rollout.log_prob_use_dynamic_bsz=${use_dynamic_bsz} \
  actor_rollout_ref.actor.ppo_max_token_len_per_gpu=${actor_ppo_max_token_len} \
  actor_rollout_ref.ref.log_prob_max_token_len_per_gpu=${infer_ppo_max_token_len} \
  actor_rollout_ref.rollout.log_prob_max_token_len_per_gpu=${infer_ppo_max_token_len} \
  actor_rollout_ref.model.path="${MODEL_PATH}" \
  +actor_rollout_ref.model.override_config.attention_dropout=0. \
  +actor_rollout_ref.model.override_config.embd_pdrop=0. \
  +actor_rollout_ref.model.override_config.resid_pdrop=0. \
  actor_rollout_ref.model.enable_gradient_checkpointing=True \
  actor_rollout_ref.actor.optim.lr=1e-6 \
  actor_rollout_ref.actor.optim.lr_warmup_steps=10 \
  actor_rollout_ref.actor.optim.weight_decay=0.1 \
  actor_rollout_ref.actor.ppo_mini_batch_size=${train_prompt_mini_bsz} \
  actor_rollout_ref.actor.fsdp_config.param_offload=${offload} \
  actor_rollout_ref.actor.fsdp_config.optimizer_offload=${offload} \
  actor_rollout_ref.actor.entropy_coeff=0 \
  actor_rollout_ref.actor.grad_clip=1.0 \
  actor_rollout_ref.actor.loss_agg_mode=${loss_agg_mode} \
  actor_rollout_ref.actor.ulysses_sequence_parallel_size=${sp_size} \
  actor_rollout_ref.rollout.gpu_memory_utilization=0.80 \
  actor_rollout_ref.rollout.tensor_model_parallel_size=${gen_tp} \
  actor_rollout_ref.rollout.enable_chunked_prefill=True \
  actor_rollout_ref.rollout.max_num_batched_tokens=$((max_prompt_length + max_response_length)) \
  actor_rollout_ref.rollout.temperature=${temperature} \
  actor_rollout_ref.rollout.top_p=${top_p} \
  actor_rollout_ref.rollout.top_k="${top_k}" \
  actor_rollout_ref.rollout.val_kwargs.temperature=${temperature} \
  actor_rollout_ref.rollout.val_kwargs.top_p=${val_top_p} \
  actor_rollout_ref.rollout.val_kwargs.top_k=${top_k} \
  actor_rollout_ref.rollout.val_kwargs.do_sample=True \
  actor_rollout_ref.rollout.val_kwargs.n=1 \
  actor_rollout_ref.rollout.enforce_eager=False \
  actor_rollout_ref.rollout.free_cache_engine=False \
  actor_rollout_ref.ref.fsdp_config.param_offload=${offload} \
  actor_rollout_ref.ref.ulysses_sequence_parallel_size=${sp_size} \
  actor_rollout_ref.actor.fsdp_config.fsdp_size=${fsdp_size} \
  reward_model.reward_manager=dapo \
  reward_model.overlong_buffer.enable=${enable_overlong_buffer} \
  reward_model.overlong_buffer.len=${overlong_buffer_len} \
  reward_model.overlong_buffer.penalty_factor=${overlong_penalty_factor} \
  custom_reward_function.path=${WORKING_DIR}/reward_fn.py \
  custom_reward_function.name=compute_accuracy_score \
  trainer.logger=['console','wandb','tensorboard'] \
  trainer.project_name="${project_name}" \
  trainer.experiment_name="${exp_name}" \
  trainer.n_gpus_per_node=${REQUIRED_GPUS} \
  trainer.nnodes="${NNODES}" \
  trainer.val_before_train=False \
  trainer.test_freq=5 \
  trainer.save_freq=5 \
  trainer.total_epochs=20 \
  trainer.default_local_dir="${CKPTS_DIR}" \
  trainer.resume_mode=auto 