This is the directory we place other lab tools in.
e.x) 3DMax, juicer_tools, hicrep, GenomeDISCO

## 3DMax
https://github.com/BDM-Lab/3DMax.git

## juicer_tools
https://s3.amazonaws.com/hicfiles.tc4ga.com/public/juicer/juicer_tools_1.22.01.jar

## DeepHiC
https://github.com/omegahh/DeepHiC

## HiCPlus 
https://github.com/wangjuan001/hicplus

## HiCSR
https://github.com/PSI-Lab/HiCSR

## GenomeDISCO
We modified GenomeDISCO to compatible with Python 3.
1. Install original GenomeDISCO by 'git clone http://github.com/kundajelab/genomedisco'

2. Copy the 'genomedisco' folder

3. command 'pip install --editable genomedisco/'

## HiCREP
We used R 4.2.4 version and install by 'devtools::install_github(“TaoYang-dev/hicrep”)'.

The input files should meet the format like below. First and second column represent genomic location and third colimn stands for contact frequency.
'''
60000	60000	100
60000	70000	100
...
'''
We modified HiCRep's get.scc function like below

'''
f1 = /PATH/OF/YOUR/ENHANCED.gz
f2 = /PATH/OF/YOUR/ORIGNIAL.gz

data1=read.table(f1)
data2=read.table(f2)

N = max(data1[, c(1:2)])/10000

mat1 = matrix(0,N,N)
mat2 = matrix(0,N,N)

d1=data1[,c(1,2,3)]
d1[,1] = d1[,1]/10000
d1[,2] = d1[,2]/10000

d2=data2[,c(1,2,3)]
d2[,1] = d2[,1]/10000
d2[,2] = d2[,2]/10000

mat1[cbind(d1[,1], d1[,2])] <- d1[,3]
mat1[cbind(d1[,2], d1[,1])] <- d1[,3]
mat2[cbind(d2[,1], d2[,2])] <- d2[,3]
mat2[cbind(d2[,2], d2[,1])] <- d2[,3]

scc.out = get.scc(mat1, mat2, resol = 10000, h = 20, lbr = 0, ubr = 5000000)
scc.out['scc']
'''