import os

import setuptools
from setuptools import find_packages
from setuptools import setup

here = os.path.abspath(os.path.dirname(__file__))

# Get the long description from the README.mf file
with open(os.path.join(here, "README.md"), encoding="utf-8") as f:
  long_description = f.read()

setup(
    long_description=long_description,
    long_description_content_type="text/markdown",
    packages=setuptools.find_packages(),
    python_requires=">=3.7",
    install_requires = [
        "pytorch-lightning==1.2.7",
        "markupsafe==2.0.1",
        "werkzeug==2.1.0",
        "h5py",
        "seaborn",
        "torchvision",
        "ipdb",
        "scipy",
        "pymunk"
    ],
    tests_require=[
        "pytest"
    ],
)