import numpy as np
import random
from scipy import stats
import torch

def von_mises(theta, mu, sigma, norm=None):
    kappa = 1 / (sigma ** 2)
    v = torch.exp(kappa * torch.cos(theta - mu))
    norm = norm or (torch.exp(kappa) / (2 * np.pi * scipy.special.i0(kappa)))
    norm = norm / torch.exp(kappa)
    v = v * norm
    return v
