import Util_import
from utils.Util_print import print_elapsed_time, print_separator
from openai import OpenAI
import json, sys

client = OpenAI()
# MODEL_NAME = "gpt-4o-mini"
MODEL_NAME = "gpt-4o"
# MODEL_NAME = "gpt-4-turbo"


from prompts_persuasion_revelation import (
    persuasion_student_task_description_system_prompt,
    persuasion_product_task_description_system_prompt,
)

query_text = """Given two concext:
====================
(GS) {GS_context}
====================
(SP) {SP_context}
====================
Which context do you think the sender would be more honest in? Why?
"""

query_input = [
    {
        "role": "user",
        "content": query_text.format(
            GS_context=persuasion_student_task_description_system_prompt,
            SP_context=persuasion_product_task_description_system_prompt,
        ),
    }
]


@print_elapsed_time
def query_GPT(conversation_history, model_name=MODEL_NAME):
    assert conversation_history
    completion = client.chat.completions.create(
        model=model_name,
        messages=conversation_history,
        # response_format={"type": "json_object"},
        max_tokens=2048,
        n=1,  # Generate 1 answer.
        temperature=0,
    )
    return completion


if __name__ == "__main__":
    output_raw = query_GPT(query_input)
    output_text = output_raw.choices[0].message.content
    print(output_text)
