#!/bin/bash
python3 ../../../main_linear.py \
    --dataset imagenet \
    --backbone resnet50 \
    --checkpoint_dir=ckpt \
    --data_dir \
    --train_dir data/train \
    --val_dir   data/val \
    --max_epochs 100 \
    --gpus 0,1 \
    --accelerator gpu \
    --strategy ddp \
    --sync_batchnorm \
    --dali \
    --precision 16 \
    --optimizer sgd \
    --scheduler step \
    --lr_decay_steps 60 80 \
    --weight_decay 0 \
    --batch_size 512 \
    --num_workers 10 \
    --pretrained_feature_extractor $2 \
    --name byol-resnet50-imagenet-linear-eval \
    --entity $ENTITY \
    --project $PROJECT \
    --save_checkpoint \
    --taus 1.0 1.5 \
    --lrs 0.2 0.5 \
    --wd1 0  \
    --wd2 1e-8 \
    --wandb

