function [A,b] = GetData(iwhich)
rand('seed',0);
randn('seed',0);
switch iwhich
    case 1
        m = 9000;
        n = 1000;
        A = GetTDT2(m,n); % sparse
    case 2
        m = 10000;
        n = 1000;
        A = Get20Newsgroups(m,n);  % sparse
    case 3
        m = 6412;
        n = 1000;
        A = GetSector(m,n);  % sparse
    case 4
        m = 2000;
        n = 784;
        A = GetDataMnist_uint8(m,n);  % sparse
    case 5
        m = 10000;
        n = 1000;
        A = GetCifar(m,n); % dense
    case 6
        m = 5000;
        n = 1000;
        A = GetGisette(m,n);% dense
    case 7
        m = 3000;
        n = 1000;
        A = GetCnn_4096d_Caltech(m,n); % dense
    case 8
        m = 10000;
        n = 1000;
        A = randn(m,n); % dense
        A = A / norm(A(:),2);
    case 9
        m = 10000;
        n = 1000;
        A = rand(m,n); % dense
        A = A / norm(A(:),2);
end


k = round(0.1*n);
x = generate_x(n,k);
Ax = A*x;
b = Ax.*Ax;
b = b + randn(m,1)*norm(b)*0.001;

A = full(A);


function A = GetTDT2(m,n)
load TDT2
A = fea;
[data_m,data_n] = size(A);
s1 = randperm(data_m,m);
s2 = randperm(data_n,n);
A = A(:,s2);
A = A(s1,:);
A = double(A);
A = A / norm(A(:),2);

function A = GetSector(m,n)
load sector_train;
A = x;
[data_m,data_n] = size(A);
s1 = randperm(data_m,m);
s2 = randperm(data_n,n);
A = A(:,s2);
A = A(s1,:);
A = double(A);
A = A / norm(A(:),2);



function x = generate_x(n,k)
p = randperm(n);
x = zeros(n,1);
x(p(1:k)) = randn(k,1)*10;

function A = GetGisette(m,n)
load gisette;
A = x;
[data_m,data_n] = size(A);
s1 = randperm(data_m,m);
s2 = randperm(data_n,n);
A = A(:,s2);
A = A(s1,:);
A = double(A);
A = A / norm(A(:),2);

function A = GetCifar(m,n)
load cifar;
A = data;
[data_m,data_n] = size(A);
s1 = randperm(data_m,m);
s2 = randperm(data_n,n);
A = A(:,s2);
A = A(s1,:);
A = double(A);
% [A] = center(A);
% [m,n] = size(A);
% for i=1:data_n
% A(:,i) = A(:,i) / norm(A(:,i),2);
% end
A = A / norm(A(:),2);

function A = GetCnn_4096d_Caltech(m,n)
load cnn_4096d_Caltech_256;
A = double(feat);
[data_m,data_n] = size(A);
s1 = randperm(data_m,m);
s2 = randperm(data_n,n);
A = A(:,s2);
A = A(s1,:);
A = double(A);
A = A / norm(A(:),2);

function A = Get20Newsgroups(m,n)
load 20Newsgroups;
A = fea;
[data_m,data_n] = size(A);
s1 = randperm(data_m,m);
s2 = randperm(data_n,n);
A = A(:,s2);
A = A(s1,:);
A = double(A);
A = A / norm(A(:),2);

function A = GetDataMnist_uint8(m,n)
load mnist_uint8;
A = train_x;
[data_m,data_n] = size(A);
s1 = randperm(data_m,m);
s2 = randperm(data_n,n);
A = A(:,s2);
A = A(s1,:);
A = double(A);
A = A / norm(A(:),2);


function A = GetRealData_w1a
load cnn_4096d_Caltech_256;
A = x;
% [data_m,data_n] = size(A);
% s1 = randperm(data_m,m);
% s2 = randperm(data_n,n);
% A = A(:,s2);
% A = A(s1,:);
A = full(A);
A = A / norm(A(:),2);

function A = GetRealDataE2006(m,n)
load E2006_5000_10000;
A = x;
[data_m,data_n] = size(A);
s1 = randperm(data_m,m);
s2 = randperm(data_n,n);
A = A(:,s2);
A = A(s1,:);
A = full(A);
A = A / norm(A(:),2);

function [A] = center(A)
[m,n] = size(A);
e = ones(m,1);
A = A - e*e'*A;








