function [X,fobjs,ts] = AAPG(X,hObjSmooth,hObjNonSmooth,hProx,timeLimit,timeIntervel,alpha,f0,L_increse_scale)

hObjF = @(X)hObjSmooth(X)+hObjNonSmooth(X);

initt = clock;
last_rec_clock = initt;
ts = []; fobjs = [];
fobjs = [fobjs;hObjF(X)];
ts = [ts;etime(clock,initt)];

% L = 10;
L0 = 0.1;
L = L0;
Y = X;
for iter = 1:100000000    
    [~,grad] = hObjSmooth(Y);
    rho = sqrt(L);
    Xt = X;
    X = hProx(Y-grad./rho,1/rho);
    Diff = X-Xt;
%    L = L + L_increse_scale*norm(Diff,'fro')^2;
       L = L + L*L_increse_scale*norm(Diff,'fro')^2;
    Y = X + alpha*Diff;    
    
    % compute statistics
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        F = hObjF(X);
        fprintf('iter:%d, diff:%e L: %e, fobj diff: %.4e \n',iter,norm(Diff,'fro'),L,F-f0);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;F];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit
            break;
        end
    end  
end
