
function [X,fobjs,ts] = AAPGL1L2(X,hObjSmooth,hObjNonSmooth,hProx,timeLimit,timeIntervel,alpha,f0)

hObjF = @(X)hObjSmooth(X)+hObjNonSmooth(X);
initt = clock;
last_rec_clock = initt;
ts = []; fobjs = [];
fobjs = [fobjs;hObjF(X)];
ts = [ts;etime(clock,initt)];

L = 10;
% L = 0.1;
Y = X;
for iter = 1:100000000    
    [~,grad] = hObjSmooth(Y);
    rho = 1*sqrt(L);
    Xt = X;
    X = hProx(Y-grad./rho,1/rho);
    Diff = X - Xt;
    L_old = L;
    L = L + norm(Diff,'fro')^2;
    Y = X + alpha*Diff;   

    % compute statistics
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        F = hObjF(X);
        fprintf('iter:%d, diff:%.2e, L:%.2e, fobj diff: %.4e \n',iter,norm(Diff,'fro'),sqrt(L),F-f0);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;F];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit
            break;
        end
    end  
end

