function [X,fobjs,ts] = ADAM_ProjGrad(X,C,B,timeLimit,timeIntervel,alpha)
HandleObjGrad = @(X)ComputeObjGrad(X,C,B);
HandleGrad = @(X)ComputeGrad(X,C,B);
[n,r] = size(X);


initt = clock;
last_rec_clock = initt;
ts = []; fobjs = [];
fobjs = [fobjs;HandleObjGrad(X)];
ts = [ts;etime(clock,initt)];

myeps = 1;
L = 1;
% alpha = 0.9;
Xo = X;
for iter = 1:150000
    
    [grad] = HandleGrad(Xo);
    rho = sqrt(L)*myeps;
    X_old = X;
    X = OrthProj(Xo - grad./rho);
    Diff = X-X_old;
%    L = L + myeps*rho.*rho.*Diff.*Diff;
    L = L + norm(Diff*rho,'fro')^2*myeps;
    Xo = X + alpha*Diff;
 

    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        fprintf('iter:%d, diff:%e, L:%e\n',iter,norm(Diff,'fro'),L);

        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;HandleObjGrad(X)];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit
            break;
        end
    end

end