function [X,fobjs,ts] = ADAM_ProjGrad_MaxX(X,C,B,timeLimit,timeIntervel,alpha)
HandleObjGrad = @(X)ComputeObjGrad(X,C,B);
HandleGrad = @(X)ComputeGrad(X,C,B);
[n,r] = size(X);


initt = clock;
last_rec_clock = initt;
ts = []; fobjs = [];
fobjs = [fobjs;HandleObjGrad(X)];
ts = [ts;etime(clock,initt)];

myeps = 0.1;
L = 0.1;
% alpha = 0.9;
Xo = X;
for iter = 1:150000
    
    [grad] = HandleGrad(Xo);
    rho = sqrt(L)*myeps;
    X_old = X;
    X = OrthProj(Xo - grad./rho);
    Diff = X-X_old;
%    L = L + myeps*rho.*rho.*Diff.*Diff;
    L = L + norm(Diff,'fro')^2*myeps*rho.*rho;

alpha = (iter - 1) / (iter+2);
    Xo = X + alpha*Diff;
 
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;HandleObjGrad(X)];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit
            break;
        end
    end

end