function X = prox_dc_l1_topk(C,rho,k)
% min_x 0.5 || X - C ||_2^2 + rho (||X||_1  -  ||X||_{topk})
X = prox_l1topk_vec(C(:),rho,k);
X = reshape(X,size(C));

function [x] = prox_l1topk_vec(c,rho,k)
% min_x 0.5 beta || x - c ||_2^2 + rho (||x||_1  -  |x|_{topk})
s = length(c) - k;
x = c;
[~,ind] = sort(abs(c),'ascend');
ind = ind(1:s);
x(ind) = prox_l1(c(ind),rho);

function [x] = prox_l1(a,lambda)
% It solves the following OP:
% min_{x} 0.5||x-a||^2 + lambda * sum(abs(x))
x = sign(a).*max(0,abs(a)-lambda);

