# Bag of Tricks for FGSM Adversarial Training

## Environment settings and libraries we used in our experiments

This project is tested under the following environment settings:
- OS: Ubuntu 18.04.4
- Cuda: 10.1, Cudnn: v7.6
- Python: 3.6
- PyTorch: >= 1.7.0
- Torchvision: >= 0.8.0



## Trick Candidates


- **FGSM-Mask**:
`python trian.py --mask --mask_ratio 0.3 --model PreActResNet18`

- **FGSM-Mask-Fixed**:
`python trian.py --mask_fix --mask_ratio 0.5 --model PreActResNet18`

- **FGSM-Str2**:
`python trian.py --str2 --model PreActResNet18`

- **FGSM-Smooth**:
`python trian.py --model PreActResNet18 --acivation Softplus --softplus_beta 2`

- **FGSM-GradNorm**:
`python trian.py --model PreActResNet18 --gradnorm --gradnorm_beta 1`


- **FGSM-ConvNorm**:
`python trian.py --model PreActResNet18 --convnorm --convnorm_beta 6`