_base_ = [
    './afformer.py', '../_base_/datasets/coco-stuff10k.py',
    '../_base_/default_runtime.py', '../_base_/schedules/schedule_80k.py',
]
model = dict(
    pretrained='ckpts/AFFormer_base_ImageNet1k_new.pth',
    backbone=dict(
        type='afformer_base',
        strides=[4, 2, 2, 2]),
    decode_head=dict(
        num_classes=171,
        in_channels=[216],
        in_index=[3],
        channels=256,
        aff_channels=256,
        aff_kwargs=dict(MD_R=16),
    )
    )

# AdamW optimizer, no weight decay for position embedding & layer norm in backbone
optimizer = dict(_delete_=True, type='AdamW', lr=0.0003, betas=(0.9, 0.999), weight_decay=0.01)

lr_config = dict(_delete_=True, policy='poly',
                 warmup='linear',
                 warmup_iters=1500,
                 warmup_ratio=1e-6,
                 power=1.0, min_lr=0.0, by_epoch=False)

# By default, models are trained on 2 GPUs with 8 images per GPU
data=dict(samples_per_gpu=4, workers_per_gpu=4)
find_unused_parameters=True
checkpoint_config = dict(by_epoch=False, interval=4000)
evaluation = dict(interval=4000, metric='mIoU', pre_eval=True)