# Interaction Warping

This codebase contains the code for both our simulation and real-world experiments.

The real-world experiments cannot be reproduce without our specific camera and robot setup.

We included the code for reference.

## Setup

Install python3 and `pip install -r requirements.txt`.

Clone and install `https://github.com/anthonysimeonov/relational_ndf`. Download all mesh data following their instructions.

Run `source rndf_env.sh` in the relational_ndf directory.

## Running simulation experiments

```
DEMOS=1
POSE="any_pose"  # Or "upright"

python -m scripts.run_warp --parent_class syn_rack_easy --child_class mug \
--exp mug_on_rack_upright_pose_new \
--parent_model_path ndf_vnn/rndf_weights/ndf_rack.pth \
--child_model_path ndf_vnn/rndf_weights/ndf_mug2.pth \
--is_child_shapenet_obj \
--rel_demo_exp release_demos/mug_on_rack_relation \
--pybullet_server \
--demo_selection \
--n_demos $DEMOS \
--parent_load_pose_type random_upright --child_load_pose_type $POSE &> outputs/mug_on_tree_${POSE}_${DEMOS}_demo_pick.txt

python -m scripts.run_warp --parent_class mug --child_class bowl \
--exp bowl_on_mug_upright_pose_new \
--parent_model_path ndf_vnn/rndf_weights/ndf_mug.pth \
--child_model_path ndf_vnn/rndf_weights/ndf_bowl.pth \
--is_parent_shapenet_obj --is_child_shapenet_obj \
--rel_demo_exp release_demos/bowl_on_mug_relation --pybullet_server \
--demo_selection \
--n_demos $DEMOS \
--parent_load_pose_type random_upright --child_load_pose_type $POSE &> bowl_on_mug_${POSE}_${DEMOS}_demo_pick.txt

python -m scripts.run_warp --parent_class syn_container --child_class bottle \
--exp bottle_in_container_upright_pose_new \
--parent_model_path ndf_vnn/rndf_weights/ndf_container.pth \
--child_model_path ndf_vnn/rndf_weights/ndf_bottle.pth \
--is_child_shapenet_obj \
--rel_demo_exp release_demos/bottle_in_container_relation \
--pybullet_server \
--pc_reference child \
--demo_selection \
--n_demos $DEMOS \
--parent_load_pose_type random_upright --child_load_pose_type $POSE &> outputs/bottle_in_box_${POSE}_${DEMOS}_demo_pick.txt
```
