#!/usr/bin/python3
"""
Registry
====

+ Dataset
+ Transforms
+ Model
+ Criterion
+ Optimizer
+ Scheduler
+ Metric
+ Logger

"""

# Registries
# ==========

DATASET_REGISTRY     = {}
TRANSFORM_REGISTRY   = {}
MODEL_REGISTRY       = {}
CRITERION_REGISTRY   = {}
OPTIMIZER_REGISTRY   = {}
SCHEDULER_REGISTRY   = {}
METRIC_REGISTRY      = {}
LOGGER_REGISTRY      = {}


# Decorators
# ==========
def register_dataset(name):
    def deco(fn):
        DATASET_REGISTRY[name] = fn
        return fn
    return deco

def register_transform(name):
    def deco(fn):
        TRANSFORM_REGISTRY[name] = fn
        return fn
    return deco

def register_model(name):
    def deco(cls):
        MODEL_REGISTRY[name] = cls
        return cls
    return deco

def register_criterion(name):
    def deco(fn):
        CRITERION_REGISTRY[name] = fn
        return fn
    return deco

def register_optimizer(name):
    def deco(fn):
        OPTIMIZER_REGISTRY[name] = fn
        return fn
    return deco

def register_scheduler(name):
    def deco(fn):
        SCHEDULER_REGISTRY[name] = fn
        return fn
    return deco

def register_metric(name):
    def deco(fn):
        METRIC_REGISTRY[name] = fn
        return fn
    return deco

def register_logger(name):
    def deco(fn):
        LOGGER_REGISTRY[name] = fn
        return fn
    return deco
