import yaml
import os

# 定义所有参数组合
params_list = [
    (-0.0027, 0.049, 0.0149, 0.010),
    (-0.0027, 0.049, 0.0149, 0.020),
    (-0.0027, 0.087, 0.0088, 0.030),
    (-0.0027, 0.087, 0.0048, 0.010),
    (-0.0027, 0.087, 0.0108, 0.010),
    (-0.0027, 0.124, 0.0108, 0.020),
    (-0.0048, 0.030, 0.0189, 0.010),
    (-0.0048, 0.087, 0.0249, 0.010),
    (-0.0068, 0.049, 0.0048, 0.030),
    (-0.0068, 0.087, 0.0027, 0.010),
    (-0.0088, 0.049, 0.0048, 0.020),
    (-0.0088, 0.106, 0.0068, 0.010),
    (-0.0108, 0.049, 0.0088, 0.020),
    (-0.0108, 0.068, 0.0108, 0.020),
]

# 基础配置
base_config = {
    "input_dim": 1,
    "output_dim": 1,
    "input_len": 100,
    "output_len": 50,
    "d_model": 256,
    "n_layer": 4,
    "batch_size": 2048,
    "lr": 1.0e-4,
    "num_epochs": 100,
    "train_ratio": 0.8,
    "val_ratio": 0.1,
    "data": {
        "type": "generate_gbm_data_multi_two",
        "num_samples": 50000,
        "save_dir": "./data"
    },
    "save": {
        "save_dir": "./checkpoints",
        "log_dir": "./logs",
        "keep_models": 3
    },
    "device": "cuda:0",
    "test_gpu": 0
}

# 创建配置目录
config_dir = "gbm_two_sde"
os.makedirs(config_dir, exist_ok=True)

# 生成配置文件
for i, (mu1, sigma1, mu2, sigma2) in enumerate(params_list, 1):
    config = base_config.copy()
    config["data"]["mu1"] = mu1
    config["data"]["sigma1"] = sigma1
    config["data"]["mu2"] = mu2
    config["data"]["sigma2"] = sigma2
    
    model_name = f"gbm_dist_mu1={mu1}_sigma1={sigma1}_mu2={mu2}_sigma2={sigma2}"
    config["save"]["model_name"] = model_name
    
    # 保存配置文件
    config_path = os.path.join(config_dir, f"{i}.yaml")
    with open(config_path, "w") as f:
        yaml.dump(config, f, default_flow_style=False)