imagenet_path=""
log_dir_vq="train_logs_vq/vqgan_lc"
log_dir_gpt="train_logs_gpt/gpt_lc"
codebook_path="clustering_codebook_imagenet1k_100000.pth"

###Eval Reconstruction
CUDA_VISIBLE_DEVICES=0 torchrun --nproc_per_node 1 --master_port=15301 eval_reconstruction.py \
        --batch_size 8 \
        --image_size 256 \
        --lr 9e-3 \
        --n_class 1000 \
        --imagenet_path $imagenet_path \
        --vq_config_path vqgan_configs/vq-f16.yaml \
        --output_dir "log_eval_recons/vqgan_lc" \
        --log_dir "log_eval_recons/vqgan_lc" \
        --quantizer_type "org" \
        --local_embedding_path $codebook_path \
        --stage_1_ckpt $log_dir_vq"/vqgan_checkpoint-20.pth" \
        --tuning_codebook 0 \
        --embed_dim 8 \
        --n_vision_words 100000 \
        --use_cblinear 1 \
        --dataset "imagenet"

###Eval Generation
CUDA_VISIBLE_DEVICES=1 torchrun --nproc_per_node 1 --master_port=13207 eval_generation_imagenet.py \
    --batch_size 50 \
    --image_size 256 \
    --epochs 100 \
    --lr 4.5e-4 \
    --n_class 1000 \
    --imagenet_path $imagenet_path \
    --num_workers 8 \
    --vq_config_path vqgan_configs/vq-f16.yaml \
    --output_dir $log_dir \
    --local_embedding_path $imagenet_path \
    --stage_1_ckpt $log_dir_vq"/vqgan_checkpoint-20.pth" \
    --stage_2_ckpt $log_dir_gpt"/transformer_100.pt" \
    --n_vision_words 100000 \
    --tuning_codebook 0 \
    --use_cblinear 1 \
    --embed_dim 8 \
    --top_k 100000 \
    --dataset "imagenet" \
    --gpt_type "small"