
from config.data import MOONS, CIRCLES, BANK, MNIST, MNIST10, CIFAR, CIFAR10
from config.kernels import QGK_STATIC, QGK, QEK, HEE, RBF, LIN, BASELINE

BASE = lambda seed: {'seed': seed, 'verbose': False}

class Config:
  def __init__(self, config:dict):
    assert isinstance(config, dict)
    for key, val in config.items():
      if isinstance(val, (list, tuple)): setattr(self, key, [x for x in val])
      else: setattr(self, key, val)
  def __setitem__(self, key, value): setattr(self, key, value)
      