QGK_STATIC = lambda eta:{
    'kernel': 'QGK',
    'kernel_kwargs': { 'eta': eta },
    'train_kwargs': { 'epochs': 0 },
}


QGK = lambda eta, epochs=1000, groups=None, hidden_dims=[]: {
  'kernel': 'QGK',
  'kernel_kwargs': {
    'eta': eta,
    'groups': groups,
    'hidden_dims': hidden_dims,
    'optimizer': 'Adam', 'lr': 10**(-(eta - 1)), 
  },
  'train_kwargs': {
    'epochs': epochs, 
    'batch_size': None
  }
}


QEK = lambda eta, epochs=1000, reupload=1: {
  'kernel': 'QEK',
  'kernel_kwargs': {
    'eta': eta,
    'reupload': reupload,
    'optimizer': 'Adam', 
    'lr': 10**(-(eta - 1)), 
  },
  'train_kwargs': {
    'epochs': epochs, 
    'batch_size': None
  }
}

HEE = lambda eta, epochs=0, layers=2, hidden_dims=[]: {
  'kernel': 'HEE',
  'kernel_kwargs': {
    'eta': eta,
    'layers': layers,
    'hidden_dims': hidden_dims,
    **({
      'optimizer': 'Adam', 'lr': 10**(-(eta - 1)),
    } if epochs > 0 else {}),
  },
  'train_kwargs': {
    'epochs': epochs, 
    'batch_size': None
  }
}

RBF = lambda epochs=0, hidden_dims=[], compression=1.0: {
  'kernel': 'RBF',
  'kernel_kwargs': {
    'hidden_dims': hidden_dims,
    'compression': compression,
    **({
      'optimizer': 'Adam', 'lr': 0.01,
    } if epochs > 0 else {}),
  },
  'train_kwargs': {
    'epochs': epochs, 
    'batch_size': None
  }
}

LIN = lambda epochs=0, hidden_dims=[], compression=1.0: {
  'kernel': 'Linear',
  'kernel_kwargs': {
    'hidden_dims': hidden_dims,
    'compression': compression,
    **({
      'optimizer': 'Adam', 'lr': 0.01,
    } if epochs > 0 else {}),
  },
  'train_kwargs': {
    'epochs': epochs, 
    'batch_size': None
  }
}

BASELINE = lambda epochs=1000, hidden_dims=[], compression=1.0, num_classes=2, lr=0.01: {
  'kernel': 'Baseline',
  'kernel_kwargs': {
    'hidden_dims': hidden_dims,
    'compression': compression,
    'num_classes': num_classes,
    'optimizer': 'Adam',
    'lr': lr,
  },
  'train_kwargs': {
    'epochs': epochs, 
    'batch_size': None
  }
}
