# Quantum Generator Kernels

## Installation

Install the required dependencies:

- [`torchquantum`](https://github.com/mit-han-lab/torchquantum) for efficient quantum simulations
- `sklearn` for fitting the SVMs and preparing the datasets
- `matplotlib` for plotting the results
- `pandas` and `numpy` for data handling

```bash
pip install -r requirements.txt
```

### Datasets

We use the `circles` and `moons` datasets from sklearn, `mnist_784` and `CIFAR_10` retrieved through sklearn, and the "Bank Marketing Dataset" `bank`.

To use the `bank` dataset, palce `bank.csv` (which can be retireved from [this url](https://archive.ics.uci.edu/dataset/222/bank+marketing)) in `data/`.

## Running Analysis

Scripts for creating the anaylysis plots are stored in the `metrics/` folder.

To reproduce the plots from the paper, use:

```bash
python metrics/1-scaling.py
python metrics/2-entanglement.py
python metrics/3-expressibility.py
python metrics/4-complexity.py
# python metrics/5-depth.py
```

## Running Evaluation

Scripts for running the evaluations are stored in the `run/` folder.

To reproduce the experiments from the paper, use:

```bash
python run/1-moons.py
python run/2-circles.py
python run/3-bank.py
python run/4-mnist10.py
python run/5-cifar10.py
```

Configs and cpu times are written to `runs.csv`, logs are written to the `logs/` folder and can be plotted using:

```bash
python run/plot moons
python run/plot circles
python run/plot bank
python run/plot mnist10
python run/plot cifar10
```

The generated plots will be stored in the  `plots/` folder.

To summarize the used compute run `python run/compute.py`.
