import matplotlib.pyplot as plt
from metrics.styles import *

# VGG Scaling with approx. exponential parameter compression
G = lambda eta: ( 2**eta )**2 - 1
g = lambda n: g(n-1) * 2 + (n%2!=0) * 2 - 1 if n > 1 else 1
groups = lambda n: G(n)/g(n)

# VQC Scaling: Assuming Maximum Embedding Deph of Eta
Q = lambda n: n**2 

plt.figure(figsize=(4, 3))

eta = range(1, 7)

# plt.plot(eta, [groups(n) for n in eta], color=blue, label='VGG(ours)', **pltargs)
plt.plot(eta, [G(n) for n in eta], color=blue, label='VGG(ours)', **pltargs)
plt.plot(eta, [Q(n) for n in eta], color=red, label='VQC', **pltargs)

plt.xlabel('Number of qubits $\eta$')
plt.ylabel('Number of parameters')
plt.legend(loc="upper left")
plt.yscale('log')
plt.tight_layout()

plt.savefig(f"plots/analysis/1-scaling.pdf")