kerFctn <- function(kernel_type) {
  if (kernel_type == "gauss") {
    ker <- function(x) {
      dnorm(x) # exp(-x^2 / 2) / sqrt(2*pi)
    }
  } else if (kernel_type == "rect") {
    ker <- function(x) {
      as.numeric((x <= 1) & (x >= -1))
    }
  } else if (kernel_type == "epan") {
    ker <- function(x) {
      n <- 1
      (2 * n + 1) / (4 * n) * (1 - x^(2 * n)) * (abs(x) <= 1)
    }
  } else if (kernel_type == "gausvar") {
    ker <- function(x) {
      dnorm(x) * (1.25 - 0.25 * x^2)
    }
  } else if (kernel_type == "quar") {
    ker <- function(x) {
      (15 / 16) * (1 - x^2)^2 * (abs(x) <= 1)
    }
  } else {
    stop("Unavailable kernel")
  }
  return(ker)
}
