
from clus.config.base_config import *

### Integrated Configs ### 
class CLUSConfig(BaseConfig) :
    def __init__(
            self,
            optimizer_config: OptimizerConfig=None,  
            input_config: InputConfig=None, 
            model_config: ModelConfig=None,
            exp_config: ExpConfig=None,
            scenario_config: ScenarioConfig=None,

        ) :
        self.optimizer_config = optimizer_config
        self.input_config = input_config
        #
        self.model_config = model_config
        self.model_config.model_kwargs['input_config'] = self.input_config
        self.model_config.model_kwargs['optimizer_config'] = self.optimizer_config


        self.exp_config = None

    def set_default_configs(self) :
        if self.model_config is None :
            self.model_config = ModelConfig()
        if self.optimizer_config is None :
            self.optimizer_config = OptimizerConfig()
        if self.input_config is None :
            self.input_config = InputConfig()







