# NeurIPS 2024 Submission Version

## Requirements

- Python version: 3.10.13
- mujoco210

## Installation Instructions

### Step 1: Create Conda Environment

Create and activate a conda environment using the `environment.yml` file.

```sh
conda env create -f environment.yml
conda activate your_environment_name
```

### Step 2: Install Specific Package Versions

Ensure that gym version 0.21.0 is used in the current code.

```sh
pip install gym==0.21.0
```

### Step 3: Modify Library Imports

Replace instances of `jax.linear_util` with `jax.extend.linear_util`.

### Step 4: Fix Potential Issues with abc

Ensure compatibility with `collections.abc.Collection`.

### Step 5: Install Necessary Packages

Navigate to the `clus` directory and run the following command to install necessary packages for the experiments:

```sh
cd clus
pip install -e .
```

### Step 6: Set Environment Variables

Set the required environment variables:

```sh
export clus_path="/home/[exp_path]/clus"
export XLA_PYTHON_CLIENT_PREALLOCATE=false
```

### Step 7: Download and Organize Datasets and Environments

Download : https://drive.google.com/file/d/1x9FjohGHyultblhQFZXXLs_FhaTYlg5F/view?usp=drive_link

After downloading the env files move the contents to the appropriate directories.

- Move `\IsCiL_Env\data` to the `\clus` subfolder.
- For the environments, run the following commands:

```sh
cd IsCiL_Env/env/mmworld
pip install -e .

cd ../Metaworld
pip install -e .
```

### Step 8: Run IsCiL

Execute the following command from the `clus` directory:

```sh
bash IsCiL.sh
```

## Future Plan

A simplified one-click installation process will be released in the future.
