#!/bin/bash
   # Script to reproduce results
 mkdir outlogs_matrix &> /dev/null
 declare -a tasks=( "matrix_game_3" )
 declare -a algos=( "vdn" "qmix" "qtran" "qatten")
 ## "dmaq" "vdn" "qmix" "qtran"
 declare -a seeds=( "0" "1" "2" "3" "4" "5")
 n=0
 gpunum=8
 for task in "${tasks[@]}"
 do
 for algo in "${algos[@]}"
 do
 for seed in "${seeds[@]}"
 do
 OMP_NUM_THREADS=8 KMP_AFFINITY="compact,granularity\=fine" CUDA_VISIBLE_DEVICES=${n} nohup python3 main.py \
 --config=${algo} --env-config=${task} with \
 local_results_path='../../../tmp_DD/'${task}'/results/' \
 save_model=True \
 use_tensorboard=True \
 save_model_interval=200000 \
 t_max=210000 \
 epsilon_finish=1.0 \
 >& outlogs_matrix/${task}_${algo}_${seed}.txt &
 echo "task: ${task}, algo: ${algo}, seed: ${seed}, GPU: $n"
 n=$((($n+1) % ${gpunum}))
 sleep 30
 done
 done
 done
